!Object constantsFor: 'Geos Libraries'!

geosLIB80 'SYSTEM\vrecui'! !

!Object constantsFor: 'Geos vardata'!

!

!Object constantsFor: 'Geos messages'!

controlInitiate 27648!
play 27649!
record 27650!
delete 27651!
close 27652!
pause 27653!
continue 27654!
uiStop 27655!
stop 27656!
setTriggers 27657!
setError 27658!
menuSelect 27659!
ctrlVolumeCommand 27660!
waitNextRoundTimer 27661!
setPause 27662!
updateState 27663!
!

!Geos class methodsFor: 'library calls'!

StartPlayVoiceFile: ptrchar with: byte with: byte
	"RetVal cdecl StartPlayVoiceFile( char*, byte, byte) in internal/resp/vrecui.goh"
	^GEOS call: ptrchar with: byte with: byte with: #[208 0 3 3 1 1 4]!

StopPlayVoiceFile: byte
	"RetVal cdecl StopPlayVoiceFile( byte) in internal/resp/vrecui.goh"
	^GEOS call: byte with: #[208 0 4 1 4]!

StartRecVoiceFile: byte
	"RetVal cdecl StartRecVoiceFile( byte) in internal/resp/vrecui.goh"
	^GEOS call: byte with: #[208 0 5 1 4]!

VrecuiCheckIfRT24: ptrTCHAR
	"RetVal cdecl VrecuiCheckIfRT24( TCHAR*) in internal/resp/vrecui.goh"
	^GEOS call: ptrTCHAR with: #[208 0 7 3 4]!

!

GenControl subclass: #VrecuiControl
	instanceVariableNames: ''
	classVariableNames: ''!

!VrecuiControl comment!
Library vrecui, file internal/resp/vrecui.goh! !

!VrecuiControl class methodsFor: 'library linkage'!

library
	^80!

entry
	^0000!
!

!VrecuiControl methodsFor: 'Geos instance variables'!

vciVisObject
	"@instance optr VCI_visObject"
	^self dwordAt: 25!

vciVisObject: value
	"@instance optr VCI_visObject"
	^self dwordAt: 25 put: value!

VolumeLevel
	"@instance byte VolumeLevel"
	^self byteAt: 29!

VolumeLevel: value
	"@instance byte VolumeLevel"
	^self byteAt: 29 put: value!

!

!VrecuiControl methodsFor: 'Geos vardata'!

!

!VrecuiControl methodsFor: 'Geos messages'!

controlInitiate: directory with: file
	"@message void MSG_VRECUI_CONTROL_INITIATE(TCHAR *directory, TCHAR *file)"
	^self geosMessage: #[108 0 1 0 3 3 0] with: directory with: file!

play
	"@message void MSG_VRECUI_PLAY()"
	^self geosMessage: #[108 1 2 0 0]!

record
	"@message void MSG_VRECUI_RECORD()"
	^self geosMessage: #[108 2 2 0 0]!

delete
	"@message void MSG_VRECUI_DELETE()"
	^self geosMessage: #[108 3 2 0 0]!

close
	"@message void MSG_VRECUI_CLOSE()"
	^self geosMessage: #[108 4 2 0 0]!

pause
	"@message void MSG_VRECUI_PAUSE()"
	^self geosMessage: #[108 5 2 0 0]!

continue
	"@message void MSG_VRECUI_CONTINUE()"
	^self geosMessage: #[108 6 2 0 0]!

uiStop
	"@message void MSG_VRECUI_UI_STOP()"
	^self geosMessage: #[108 7 2 0 0]!

stop
	"@message void MSG_VRECUI_STOP()"
	^self geosMessage: #[108 8 2 0 0]!

setTriggers: statePlay with: stateRec
	"@message void MSG_VRECUI_SET_TRIGGERS(byte statePlay, byte stateRec)"
	^self geosMessage: #[108 9 1 0 1 1 0] with: statePlay with: stateRec!

setError
	"@message void MSG_VRECUI_SET_ERROR()"
	^self geosMessage: #[108 10 2 0 0]!

menuSelect
	"@message void MSG_VRECUI_MENU_SELECT()"
	^self geosMessage: #[108 11 2 0 0]!

ctrlVolumeCommand: commandId
	"@message void MSG_VRECUI_CTRL_VOLUME_COMMAND( word commandId)"
	^self geosMessage: #[108 12 1 0 1 0] with: commandId!

waitNextRoundTimer
	"@message void MSG_START_WAIT_NEXT_ROUND_TIMER()"
	^self geosMessage: #[108 13 2 0 0]!

setPause: Pause with: Continue
	"@message void MSG_VRECUI_SET_PAUSE(byte Pause, byte Continue)"
	^self geosMessage: #[108 14 1 0 1 1 0] with: Pause with: Continue!

updateState
	"@message void MSG_VRECUI_UPDATE_STATE()"
	^self geosMessage: #[108 15 2 0 0]!

!

